@extends('layouts.app')

@section('title', 'Notifications')

@section('content')
<div class="notifications-page">
    <div class="notifications-container">
        <div class="notifications-header">
            <h1>Notifications</h1>
            
            @if($notifications->total() > 0)
                <div class="notifications-actions">
                    <form action="{{ route('notifications.mark-all-read') }}" method="POST" class="inline">
                        @csrf
                        <button type="submit" class="btn btn-primary">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <polyline points="20,6 9,17 4,12"></polyline>
                            </svg>
                            Mark All Read
                        </button>
                    </form>
                    
                    <form action="{{ route('notifications.destroy-all') }}" method="POST" class="inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" 
                                onclick="return confirm('Are you sure you want to delete all notifications?')"
                                class="btn btn-danger">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <polyline points="3,6 5,6 21,6"></polyline>
                                <path d="m19,6v14a2,2 0 0,1 -2,2H7a2,2 0 0,1 -2,-2V6m3,0V4a2,2 0 0,1 2,-2h4a2,2 0 0,1 2,2v2"></path>
                            </svg>
                            Delete All
                        </button>
                    </form>
                </div>
            @endif
        </div>

        @if($notifications->count() > 0)
            <div class="notifications-content">
                @foreach($notifications as $notification)
                    <div class="notification-card {{ $notification->read_at ? '' : 'unread' }}">
                        <div class="notification-main">
                            @if(isset($notification->data['reactor_avatar']) || isset($notification->data['replier_avatar']))
                                <img src="{{ $notification->data['reactor_avatar'] ?? $notification->data['replier_avatar'] }}" 
                                     alt="Avatar" 
                                     class="notification-avatar">
                            @else
                                <div class="notification-avatar" style="background: var(--dark-gray-lightest); display: flex; align-items: center; justify-content: center;">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="12" cy="7" r="4"></circle>
                                    </svg>
                                </div>
                            @endif
                            
                            <div class="notification-details">
                                <div class="notification-message">
                                    {{ $notification->data['message'] }}
                                    @if(isset($notification->data['reaction_emoji']))
                                        <span class="reaction-emoji">{{ $notification->data['reaction_emoji'] }}</span>
                                    @endif
                                </div>
                                
                                @if(isset($notification->data['post_content_preview']))
                                    <div class="notification-preview">
                                        "{{ $notification->data['post_content_preview'] }}"
                                    </div>
                                @endif
                                
                                <div class="notification-meta">
                                    <span class="notification-time">{{ $notification->created_at->diffForHumans() }}</span>
                                    
                                    @if(!$notification->read_at)
                                        <span class="notification-status unread">Unread</span>
                                    @else
                                        <span class="notification-status read">Read</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                        <div class="notification-actions">
                            @if(!$notification->read_at)
                                <form action="{{ route('notifications.read', $notification->id) }}" method="POST" class="inline">
                                    @csrf
                                    <button type="submit" class="btn btn-secondary btn-sm">
                                        Mark Read
                                    </button>
                                </form>
                            @endif
                            
                            @if(isset($notification->data['url']))
                                <form action="{{ route('notifications.read', $notification->id) }}" method="POST" class="inline">
                                    @csrf
                                    <input type="hidden" name="redirect_url" value="{{ $notification->data['url'] }}">
                                    <button type="submit" class="btn btn-primary btn-sm">
                                        <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M9 18l6-6-6-6"></path>
                                        </svg>
                                        View
                                    </button>
                                </form>
                            @endif
                            
                            <form action="{{ route('notifications.destroy', $notification->id) }}" method="POST" class="inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" 
                                        onclick="return confirm('Are you sure you want to delete this notification?')"
                                        class="btn btn-link btn-sm">
                                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <polyline points="3,6 5,6 21,6"></polyline>
                                        <path d="m19,6v14a2,2 0 0,1 -2,2H7a2,2 0 0,1 -2,-2V6m3,0V4a2,2 0 0,1 2,-2h4a2,2 0 0,1 2,2v2"></path>
                                    </svg>
                                    Delete
                                </button>
                            </form>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="notifications-pagination">
                {{ $notifications->links() }}
            </div>
        @else
            <div class="notifications-content">
                <div class="notifications-empty">
                    <div class="empty-icon">🔔</div>
                    <h3 class="empty-title">No notifications yet</h3>
                    <p class="empty-description">
                        You'll see notifications here when someone interacts with your posts or threads. 
                        Start engaging with the community to get notified!
                    </p>
                </div>
            </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
// Auto-refresh unread count every 30 seconds
setInterval(function() {
    fetch('{{ route('notifications.unread-count') }}')
        .then(response => response.json())
        .then(data => {
            const badge = document.querySelector('.notification-badge');
            if (badge) {
                badge.textContent = data.count;
                badge.classList.toggle('hidden', data.count === 0);
            }
        })
        .catch(error => console.error('Error updating notification count:', error));
}, 30000);
</script>
@endpush
@endsection